/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.launcher;

import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class LauncherCreator {
    private Window owner;
    private JFileChooser fcJRE;
    private JFileChooser fcBAT;

    public void open(Window window) {
        File file;
        PrintStream printStream;
        File file2;
        this.owner = window;
        boolean bl = false;
        do {
            if ((file2 = this.selectJRE()) != null) continue;
            return;
        } while (!this.checkJRE(file2));
        do {
            if ((file = this.selectBAT()) != null) continue;
            return;
        } while ((printStream = this.openBAT(file)) == null);
        try {
            bl = this.createLauncher(file2, printStream);
        }
        catch (Throwable throwable) {
            try {
                printStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            printStream.close();
        }
        catch (Exception exception) {}
        if (bl) {
            JOptionPane.showMessageDialog(window, new String[]{"The launcher script has successfully been created.", "You can now use it to launch ParaJVE with the selected JRE.", " ", "Have fun ! :)"}, "Launcher created", 1);
        }
    }

    private final File selectJRE() {
        if (this.fcJRE == null) {
            this.fcJRE = new JFileChooser(System.getProperty("user.dir"));
            this.fcJRE.setDialogTitle("Select a JRE with a version 1.5 (or greater)...");
            FileFilter[] fileFilterArray = this.fcJRE.getChoosableFileFilters();
            if (fileFilterArray != null) {
                int n = 0;
                while (n < fileFilterArray.length) {
                    this.fcJRE.removeChoosableFileFilter(fileFilterArray[n]);
                    ++n;
                }
            }
            this.fcJRE.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isFile() || file.getName().toLowerCase().equals("java.exe");
                }

                public String getDescription() {
                    return " java.exe";
                }
            });
        }
        this.fcJRE.setDialogType(0);
        if (this.fcJRE.showDialog(this.owner, "Select JRE") != 0) {
            return null;
        }
        return this.fcJRE.getSelectedFile();
    }

    private final File selectBAT() {
        if (this.fcBAT == null) {
            this.fcBAT = new JFileChooser(System.getProperty("user.dir"));
            this.fcBAT.setDialogTitle("Select the launcher file to create...");
            this.fcBAT.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isFile() || file.getName().toLowerCase().endsWith(".bat");
                }

                public String getDescription() {
                    return " *.bat";
                }
            });
        }
        this.fcBAT.setDialogType(1);
        if (this.fcBAT.showDialog(this.owner, "Create Launcher") != 0) {
            return null;
        }
        File file = this.fcBAT.getSelectedFile();
        if (file != null && !file.getName().toLowerCase().endsWith(".bat")) {
            file = new File(file.getParentFile(), String.valueOf(file.getName()) + ".bat");
        }
        return file;
    }

    private final boolean checkJRE(File file) {
        String string;
        block9: {
            String string2;
            int n;
            block8: {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{file.getCanonicalPath(), "-version"});
                    InputStream inputStream = process.getErrorStream();
                    process.waitFor();
                    StringBuffer stringBuffer = new StringBuffer(inputStream.available());
                    try {
                        int n2;
                        while ((n2 = inputStream.read()) >= 0) {
                            stringBuffer.append((char)n2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.err);
                        return this.displayError("Could not check the selected JRE version.", "Please select another one.");
                    }
                    String string3 = stringBuffer.toString().toLowerCase();
                    n = string3.indexOf(34, 14);
                    if (!string3.startsWith("java version \"") || n < 0) {
                        return this.displayError("Cannot fetch the version of the selected JRE.", "Please select another one.");
                    }
                    string = string3.substring(14, n);
                    char c = string.charAt(0);
                    if (c < '2' || c > '9') break block8;
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                    return this.displayError("An error occured when checking the selected JRE version.", "Please select another one.");
                }
            }
            if (!string.startsWith("1.")) break block9;
            n = string.indexOf(46, 2);
            String string4 = string2 = n > 0 ? string.substring(2, n) : string.substring(2);
            if (Integer.parseInt(string2) < 5) break block9;
            return true;
        }
        return this.displayError("The selected JRE's version (" + string + ") doesn't appear to be 1.5 (or greater).", "Please select another one.");
    }

    private final PrintStream openBAT(File file) {
        String[] stringArray;
        int n;
        if (file.isFile() && (n = JOptionPane.showConfirmDialog(this.owner, stringArray = new String[]{"The selected launcher file already exist.", "OK to overwrite \"" + file.getName() + "\" ?"}, "Confirm Overwrite", 0, 2)) != 0) {
            return null;
        }
        try {
            return new PrintStream(new FileOutputStream(file), true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            this.displayError("Cannot open \"" + file.getName() + "\" for writting.", "Please select another launcher file to create", "Creation Error", 0);
            return null;
        }
    }

    private boolean createLauncher(File file, PrintStream printStream) {
        File file2 = new File(file.getParentFile(), "javaw.exe");
        if (file2.isFile()) {
            file = file2;
        }
        try {
            printStream.println("@REM  ");
            printStream.println("@REM  Launching file generated by ParaJVE (selects a specific 1.5 JRE to run).");
            printStream.println("@REM  ");
            printStream.println("@REM  This launcher disables the use of DirectDraw by Java (forces Java2D to");
            printStream.println("@REM  use GDI), for compatibility issues between DirectDraw and OpenGL.");
            printStream.println("@REM  ");
            printStream.println("@REM  The supported command line parameters are described in the User Guide.");
            printStream.println("@REM  ");
            printStream.println("@set JAVAEXEC=" + file.getCanonicalPath());
            printStream.println("@start \"ParaJVE\" \"%JAVAEXEC%\" -Djava.library.path=libs/natives -Dsun.java2d.noddraw=true -cp libs/ParaJVE.jar;libs/jogl.jar;libs/gluegen-rt.jar;libs/jinput.jar ParaJVE %*%");
            return true;
        }
        catch (IOException iOException) {
            this.displayError("An I/O error occured while creating the launcher file.", "Its content is likely to be invalid", "Launcher creation error", 0);
            return false;
        }
    }

    private boolean displayError(String string, String string2) {
        return this.displayError(string, string2, "Invalid Selection", 1);
    }

    private boolean displayError(String string, String string2, String string3, int n) {
        JOptionPane.showMessageDialog(this.owner, new String[]{string, string2}, string3, n);
        return false;
    }
}

